<?php
class Api
{
    public $api_url = 'https://domain.com/api'; // API URL
    public $api_key = ''; // Your API key

    public function order($data) { // add order
        $post = array_merge(array('apiKey' => $this->api_key, 'actionType' => 'add'), $data);
        return json_decode($this->connect($post));
    }

    public function status($order_id) { // get order status
        return json_decode($this->connect(array(
            'apiKey' => $this->api_key,
            'actionType' => 'status',
            'orderID' => $order_id
        )));
    }

    public function multiStatus($order_ids) { // get order status
        return json_decode($this->connect(array(
            'apiKey' => $this->api_key,
            'actionType' => 'mass_status',
            'orderID' => implode(",", (array)$order_ids)
        )));
    }

    public function services() { // get services
        return json_decode($this->connect(array(
            'apiKey' => $this->api_key,
            'actionType' => 'services',
        )));
    }

    public function balance() { // get balance
        return json_decode($this->connect(array(
            'apiKey' => $this->api_key,
            'actionType' => 'balance',
        )));
    }


    private function connect($post) {
        $_post = Array();
        if (is_array($post)) {
            foreach ($post as $name => $value) {
                $_post[] = $name.'='.urlencode($value);
            }
        }

        $ch = curl_init($this->api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        if (is_array($post)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
        }
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }
        curl_close($ch);
        return $result;
    }
}

// Examples

$api = new Api();

$services = $api->services(); # return all services

$balance = $api->balance(); # return user balance

// add order

$order = $api->order(array('orderType' => 1, 'orderUrl' => 'http://example.com/test', 'orderQuantity' => 100)); # Default

$order = $api->order(array('orderType' => 1, 'orderUrl' => 'http://example.com/test', 'comment_strings' => "good pic\ngreat photo\n:)\n;)")); # Custom Comments

$order = $api->order(array('orderType' => 1, 'orderUrl' => 'http://example.com/test', 'orderQuantity' => 100, 'runs' => 10, 'interval' => 60)); # Drip-feed

$status = $api->status($order->order); # return status, charge, remains, start count, currency

$statuses = $api->multiStatus([1, 2, 3]); # return orders status, charge, remains, start count, currency


?>